/*
 * Decompiled with CFR 0.152.
 */
package com.elenai.elenaidodge.network.message;

import com.elenai.elenaidodge.ElenaiDodge;
import com.elenai.elenaidodge.event.ArmorTickEventListener;
import com.elenai.elenaidodge.util.ClientStorage;
import io.netty.buffer.ByteBuf;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.relauncher.Side;

public class CUpdateCooldownMessage
implements IMessage {
    private int regenRate;
    private boolean messageValid;

    public CUpdateCooldownMessage() {
        this.messageValid = false;
    }

    public CUpdateCooldownMessage(int regenRate) {
        this.regenRate = regenRate;
        this.messageValid = true;
    }

    public void fromBytes(ByteBuf buf) {
        try {
            this.regenRate = buf.readInt();
        }
        catch (IndexOutOfBoundsException ioe) {
            ElenaiDodge.LOG.error("Error occured whilst networking!", (Throwable)ioe);
            return;
        }
        this.messageValid = true;
    }

    public void toBytes(ByteBuf buf) {
        if (!this.messageValid) {
            return;
        }
        buf.writeInt(this.regenRate);
    }

    public static class Handler
    implements IMessageHandler<CUpdateCooldownMessage, IMessage> {
        public IMessage onMessage(CUpdateCooldownMessage message, MessageContext ctx) {
            if (!message.messageValid && ctx.side != Side.CLIENT) {
                return null;
            }
            FMLCommonHandler.instance().getWorldThread(ctx.netHandler).func_152344_a(() -> this.processMessage(message, ctx));
            return null;
        }

        void processMessage(CUpdateCooldownMessage message, MessageContext ctx) {
            ClientStorage.regenSpeed = message.regenRate;
            ArmorTickEventListener.previousArmor.clear();
        }
    }
}

